<?php
$exploded = explode('-', $data_cb);
$cb = $exploded[0];
$cb_id = $exploded[1];

if ($text == '/start') {
    $keyboard = [
        'keyboard' => [
            [
                ['text' => 'ایجاد محصول'],
                ['text' => 'ویرایش محصول']
            ]
        ],
        'resize_keyboard' => true
    ];
    sendMessage($chat_id, 'سلام ادمین', null, $keyboard);
    set_status($chat_id, "main_menu-0");

} elseif ($text == 'ایجاد محصول') {
    sendMessage($chat_id, 'نام محصول را وارد کنید');
    set_status($chat_id, 'product_title-0');

} elseif ($text == 'ویرایش محصول') {
    $sql = db_query("SELECT * FROM products WHERE status='completed'");
    $result = '';
    if ($sql && mysqli_num_rows($sql) > 0) {
        $products = mysqli_fetch_all($sql, MYSQLI_ASSOC);
        foreach ($products as $product) {
            $product_price = number_format($product['price']);
            $result .= "{$product['ID']} | {$product['title']} : {$product_price} درهم\n";
        }
        sendMessage($chat_id, $result);
        sendMessage($chat_id, "آیدی محصول مورد نظر را ارسال کنید");
        set_status($chat_id, "edit_product-0");
    } else {
        sendMessage($chat_id, "هیچ محصولی جهت ویرایش وجود ندارد");
    }

} elseif ($cb == 'confirm_payment') {
    $payment_id = $cb_id;
    $payment = mysqli_fetch_assoc(mysqli_query(db(), "SELECT * FROM payments WHERE id=$payment_id"));
    if ($payment) {
        mysqli_query(db(), "UPDATE payments SET status='confirmed' WHERE id=$payment_id");
        $user_id = $payment['user_id'];
        $product_id = $payment['product_id'];
        $product = mysqli_fetch_assoc(mysqli_query(db(), "SELECT * FROM products WHERE ID=$product_id"));
        
        // دریافت اطلاعات کاربر
        $user = mysqli_fetch_assoc(mysqli_query(db(), "SELECT * FROM users WHERE user_id=$user_id"));
        
        // ارسال پیام به کاربر
        sendMessage($user_id, "✅ پرداخت شما توسط ادمین تأیید شد و محصول شما ارسال می‌شود.");
        
        // ارسال اطلاعات به ادمین
        $admin_message = "✅ پرداخت تأیید شد\n\n";
        $admin_message .= "📦 محصول: {$product['title']}\n\n";
        $admin_message .= "👤 اطلاعات مشتری:\n";
        $admin_message .= "📛 نام: {$user['fullname']}\n";
        $admin_message .= "📞 تلفن: {$user['phone']}\n";
        $admin_message .= "🏙️ شهر: {$user['city']}\n";
        $admin_message .= "📍 آدرس: {$user['address']}\n";
        $admin_message .= "📮 کد پستی: {$user['zip_code']}";
        
        sendMessage($chat_id, $admin_message);
        
        // حذف پیام پرداخت
        curlRequest('deleteMessage', [
            'chat_id' => $chat_id,
            'message_id' => $message_id
        ]);
        
        set_status($user_id, 'main_menu-0');
    }

} elseif ($cb == 'reject_payment') {
    $payment_id = $cb_id;
    $payment = mysqli_fetch_assoc(mysqli_query(db(), "SELECT * FROM payments WHERE id=$payment_id"));
    if ($payment) {
        mysqli_query(db(), "UPDATE payments SET status='rejected' WHERE id=$payment_id");
        $user_id = $payment['user_id'];
        
        // ارسال پیام به کاربر
        sendMessage($user_id, "❌ پرداخت شما توسط ادمین رد شد. لطفا با پشتیبانی تماس بگیرید.");
        
        // حذف پیام پرداخت
        curlRequest('deleteMessage', [
            'chat_id' => $chat_id,
            'message_id' => $message_id
        ]);
        
        sendMessage($chat_id, "❌ پرداخت توسط ادمین رد شد.");
        set_status($user_id, 'main_menu-0');
    }

} elseif ($status_main == 'product_title') {
    $text_escaped = mysqli_real_escape_string(db(), $text);
    $save = db_query("INSERT INTO products (title) VALUES ('$text_escaped')");
    if ($save) {
        $product_id = mysqli_insert_id(db());
        sendMessage($chat_id, "نام محصول ذخیره شد. لطفا عکس محصول را ارسال کنید.");
        set_status($chat_id, "product_photo-$product_id");
    } else {
        sendMessage($chat_id, "خطا در ذخیره نام محصول");
    }

} elseif ($status_main == 'product_photo') {
    if (isset($message['photo'])) {
        $file_id = end($message['photo'])['file_id'];
        $update = db_update('products', "photo='$file_id'", "ID=$status_id");
        if ($update) {
            sendMessage($chat_id, 'ویژگی های محصول را هر کدام در یک سطر ارسال کنید');
            set_status($chat_id, "product_property-$status_id");
        } else {
            sendMessage($chat_id, 'خطا در ذخیره عکس');
        }
    } else {
        sendMessage($chat_id, 'لطفا یک تصویر ارسال کنید');
    }

} elseif ($status_main == 'product_property') {
    $properties = array_filter(explode("\n", $text), 'trim');
    $properties_json = json_encode($properties, JSON_UNESCAPED_UNICODE);
    $properties_json_escaped = mysqli_real_escape_string(db(), $properties_json);
    $update = db_update('products', "propertys='$properties_json_escaped'", "ID=$status_id");
    if ($update) {
        sendMessage($chat_id, 'قیمت محصول را به درهم وارد کنید');
        set_status($chat_id, "product_price-$status_id");
    } else {
        sendMessage($chat_id, 'خطا در ذخیره ویژگی ها');
    }

} elseif ($status_main == 'product_price') {
    if (is_numeric($text)) {
        $price = floatval($text);
        $update = db_update('products', "price=$price", "ID=$status_id");
        if ($update) {
            sendMessage($chat_id, 'وزن محصول را به گرم وارد کنید:');
            set_status($chat_id, "product_weight-$status_id");
        }
    } else {
        sendMessage($chat_id, 'لطفا یک عدد معتبر وارد کنید');
    }

} elseif ($status_main == 'product_weight') {
    if (is_numeric($text)) {
        $weight = floatval($text);
        $update = db_update('products', "weight='$weight'", "ID=$status_id");
        if ($update) {
            sendMessage($chat_id, 'ارزش محصول را به ریال وارد کنید:');
            set_status($chat_id, "product_value-$status_id");
        }
    } else {
        sendMessage($chat_id, 'لطفا وزن محصول را به عدد وارد کنید (گرم)');
    }

} elseif ($status_main == 'product_value') {
    if (is_numeric($text)) {
        $value = floatval($text);
        $update = db_update('products', "package_value='$value'", "ID=$status_id");
        if ($update) {
            // ایجاد کیبورد برای انتخاب بسته‌بندی
            $packingId = [
                514 => ['title' => 'کارتن سایز 12 (30*20*15)'],
                50 => ['title' => 'کارتن سایز 11 (45*35*10)'],
                49 => ['title' => 'کارتن سایز 10 (35*25*10)'],
                11 => ['title' => 'کارتن سایز 9 (55*45*35)'],
                10 => ['title' => 'کارتن سایز 8 (45*40*30)'],
                9 => ['title' => 'کارتن سایز 7 (40*30*25)'],
                8 => ['title' => 'کارتن سایز 6 (45*25*20)'],
                7 => ['title' => 'کارتن سایز 5 (35*25*20)'],
                6 => ['title' => 'کارتن سایز 4 (30*20*20)'],
                5 => ['title' => 'کارتن سایز 3 (20*20*15)'],
                4 => ['title' => 'کارتن سایز 2 (20*15*10)'],
                3 => ['title' => 'کارتن سایز 1 (15*10*10)'],
                504 => ['title' => 'بدون بسته بندی']
            ];

            $keyboard_buttons = [];
            foreach ($packingId as $id => $pack) {
                $keyboard_buttons[] = [['text' => $pack['title'], 'callback_data' => "pack_$id"]];
            }

            $reply_markup = [
                'inline_keyboard' => $keyboard_buttons
            ];

            sendMessage($chat_id, '💰 ارزش محصول ذخیره شد. لطفا سایز بسته‌بندی محصول را انتخاب کنید:', null, json_encode($reply_markup));
            set_status($chat_id, "product_packingid-$status_id");
        }
    } else {
        sendMessage($chat_id, 'لطفا ارزش محصول را به عدد وارد کنید (ریال)');
    }

} elseif ($status_main == 'product_packingid') {
    // پردازش callback برای انتخاب بسته‌بندی
    if (isset($data_cb) && strpos($data_cb, 'pack_') === 0) {
        $pack_id = str_replace('pack_', '', $data_cb);
        $callback_query_id = $data['callback_query']['id'];

        // اگر بدون بسته‌بندی انتخاب شد
        if ($pack_id == '504') {
            answerCallbackQuery($callback_query_id, "📦 بدون بسته‌بندی انتخاب شد");
            sendMessage($chat_id, "📦 طول محصول را به سانتی‌متر وارد کنید:");
            set_status($chat_id, "product_length-$status_id");
        } else {
            // ذخیره packid در دیتابیس
            $update = db_update('products', "packing_id='$pack_id', length=NULL, width=NULL, height=NULL", "ID=$status_id");

            if ($update) {
                answerCallbackQuery($callback_query_id, "✅ بسته‌بندی انتخاب شد");

                $keyboard = [
                    'keyboard' => [
                        [['text' => 'اتمام گالری']]
                    ],
                    'resize_keyboard' => true
                ];

                sendMessage($chat_id, '✅ بسته‌بندی ذخیره شد. حالا فایل‌های گالری محصول را ارسال کنید یا برای اتمام دکمه زیر را بزنید.', null, $keyboard);
                set_status($chat_id, "product_gallery-$status_id");
            } else {
                answerCallbackQuery($callback_query_id, "❌ خطا در ذخیره بسته‌بندی");
                sendMessage($chat_id, '❌ خطا در ذخیره بسته‌بندی');
            }
        }
    }

} elseif ($status_main == 'product_length') {
    if (is_numeric($text)) {
        $length = intval($text);
        $update = db_update('products', "length='$length'", "ID=$status_id");
        if ($update) {
            sendMessage($chat_id, "📦 عرض محصول را به سانتی‌متر وارد کنید:");
            set_status($chat_id, "product_width-$status_id");
        }
    } else {
        sendMessage($chat_id, "لطفا طول محصول را به عدد وارد کنید (سانتی‌متر)");
    }

} elseif ($status_main == 'product_width') {
    if (is_numeric($text)) {
        $width = intval($text);
        $update = db_update('products', "width='$width'", "ID=$status_id");
        if ($update) {
            sendMessage($chat_id, "📦 ارتفاع محصول را به سانتی‌متر وارد کنید:");
            set_status($chat_id, "product_height-$status_id");
        }
    } else {
        sendMessage($chat_id, "لطفا عرض محصول را به عدد وارد کنید (سانتی‌متر)");
    }

} elseif ($status_main == 'product_height') {
    if (is_numeric($text)) {
        $height = intval($text);
        // ذخیره ابعاد و packid برای بدون بسته‌بندی
        $update = db_update('products', "height='$height', packing_id='504'", "ID=$status_id");
        if ($update) {
            $keyboard = [
                'keyboard' => [
                    [['text' => 'اتمام گالری']]
                ],
                'resize_keyboard' => true
            ];

            sendMessage($chat_id, '✅ ابعاد محصول ذخیره شد. حالا فایل‌های گالری محصول را ارسال کنید یا برای اتمام دکمه زیر را بزنید.', null, $keyboard);
            set_status($chat_id, "product_gallery-$status_id");
        }
    } else {
        sendMessage($chat_id, "لطفا ارتفاع محصول را به عدد وارد کنید (سانتی‌متر)");
    }

} elseif ($status_main == 'product_gallery') {
    if ($text == 'اتمام گالری') {
        $query = db_query("SELECT * FROM products WHERE ID=$status_id");
        if ($query && mysqli_num_rows($query) > 0) {
            $product = mysqli_fetch_assoc($query);
            $caption = generateProductCaption($product);

            $params = [
                'photo' => $product['photo'],
                'caption' => $caption,
                'chat_id' => "@mokhtari0_shop",
                'reply_markup' => json_encode([
                    'inline_keyboard' => [
                        [['text' => '🛒 سفارش محصول', 'url' => "https://t.me/mokhtarishop_bot?start=$status_id"]]
                    ]
                ])
            ];

            $result = curlRequest('sendPhoto', $params);

            db_update('products', "status='completed'", "ID=$status_id");

            if ($result && $result['ok']) {
                $message_id = $result['result']['message_id'];
                db_update('products', "message_id='$message_id'", "ID=$status_id");

                $keyboard = [
                    'keyboard' => [
                        [
                            ['text' => 'ایجاد محصول'],
                            ['text' => 'ویرایش محصول']
                        ]
                    ],
                    'resize_keyboard' => true
                ];
                sendMessage($chat_id, "✅ محصول با موفقیت در کانال منتشر شد\n🆔 آیدی پیام: $message_id", null, $keyboard);
                set_status($chat_id, "main_menu-0");
            } else {
                sendMessage($chat_id, "❌ خطا در ارسال به کانال");
            }
        } else {
            sendMessage($chat_id, "❌ محصول یافت نشد");
        }
    } else {
        $saved = save_file($message, $status_id);
        if ($saved) {
            sendMessage($chat_id, "✅ فایل به گالری اضافه شد. فایل دیگری ارسال کنید یا برای اتمام دکمه 'اتمام گالری' را بزنید.");
        } else {
            sendMessage($chat_id, "❌ خطا در ذخیره فایل. لطفا یک عکس ارسال کنید.");
        }
    }

} elseif ($status_main == 'edit_product' && $status_id == 0) {
    if (is_numeric($text)) {
        $product_id = intval($text);
        $check_product = db_query("SELECT * FROM products WHERE ID=$product_id");
        if ($check_product && mysqli_num_rows($check_product) > 0) {
            sendMessage($chat_id, 'قیمت جدید را وارد کنید');
            set_status($chat_id, "edit_product-$product_id");
        } else {
            sendMessage($chat_id, '❌ محصولی با این آیدی وجود ندارد');
        }
    } else {
        sendMessage($chat_id, 'لطفا آیدی محصول را وارد کنید');
    }

} elseif ($status_main == 'edit_product' && $status_id != 0) {
    if (is_numeric($text)) {
        $new_price = floatval($text);
        $update = db_update('products', "price='$new_price'", "ID=$status_id");

        if ($update) {
            $product_query = db_query("SELECT * FROM products WHERE ID=$status_id");
            if ($product_query && mysqli_num_rows($product_query) > 0) {
                $product = mysqli_fetch_assoc($product_query);

                if (!empty($product['message_id'])) {
                    $new_caption = generateProductCaption($product);

                    $reply_markup = json_encode([
                        'inline_keyboard' => [
                            [['text' => '🛒 سفارش محصول', 'url' => "https://t.me/mokhtarishop_bot?start=$status_id"]]
                        ]
                    ]);

                    $edit_result = editMessageCaption("@mokhtari0_shop", $product['message_id'], $new_caption, $reply_markup);

                    if ($edit_result && $edit_result['ok']) {
                        sendMessage($chat_id, "✅ قیمت با موفقیت تغییر کرد و پیام کانال به‌روزرسانی شد");
                    } else {
                        sendMessage($chat_id, "✅ قیمت تغییر کرد اما خطا در به‌روزرسانی پیام کانال");
                    }
                } else {
                    sendMessage($chat_id, "✅ قیمت با موفقیت تغییر کرد (پیام کانال یافت نشد)");
                }
            }

            set_status($chat_id, "main_menu-0");
        } else {
            sendMessage($chat_id, "❌ خطا در ویرایش قیمت");
        }
    } else {
        sendMessage($chat_id, 'لطفا یک عدد وارد کنید');
    }
} else {
    sendMessage($chat_id, 'دستور نامعتبر است');
}
?>